/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.swing;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import oracle.install.commons.swing.Banner;
import oracle.install.commons.swing.LayoutUtils;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.GraphicalStatusControl;

public class BannerFrame
extends JFrame {
    private JPanel contentPane;
    private Banner banner;
    private String bannerText;
    private Icon bannerIcon;
    public static final String PROPERTY_BANNER_TEXT = "BannerFrame.bannerText";
    public static final String PROPERTY_BANNER_ICON = "BannerFrame.bannerIcon";

    public BannerFrame() throws HeadlessException {
        this.buildUI();
    }

    public BannerFrame(GraphicsConfiguration gc) {
        super(gc);
        this.buildUI();
    }

    public BannerFrame(String title, GraphicsConfiguration gc) {
        super(title, gc);
        this.buildUI();
    }

    public BannerFrame(String title) throws HeadlessException {
        super(title);
        this.buildUI();
    }

    protected void buildUI() {
        Application application = Application.getInstance();
        String title = this.getTitle();
        if (title == null || title.trim().length() == 0) {
            super.setTitle(application.getName());
        }
        this.banner = new Banner();
        this.addPropertyChangeListener(PROPERTY_BANNER_TEXT, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                BannerFrame.this.banner.setText((String)evt.getNewValue());
            }
        });
        this.addPropertyChangeListener(PROPERTY_BANNER_ICON, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                BannerFrame.this.banner.setIcon((Icon)evt.getNewValue());
            }
        });
        ImageIcon imageIcon = application.getIcon("application.logo", new Object[0]);
        if (imageIcon != null) {
            this.banner.setIcon(imageIcon);
        } else {
            imageIcon = application.getIcon("banner.icon", new Object[0]);
            if (imageIcon != null) {
                this.banner.setIcon(imageIcon);
            }
        }
        String text = application.getString("banner.text", title, new Object[0]);
        this.banner.setText(text);
        imageIcon = application.getIcon("application.icon", new Object[0]);
        if (imageIcon != null) {
            super.setIconImage(imageIcon.getImage());
        }
        this.contentPane = new JPanel(new BorderLayout());
        application.setStatusControl(new GraphicalStatusControl(this.contentPane));
        Insets insets = new Insets(0, 0, 0, 0);
        JPanel mainPane = new JPanel(new GridBagLayout());
        LayoutUtils.addComponent(this.banner, mainPane, 0, 0, 1, 1, 2, 10, 1.0, 0.0, insets);
        LayoutUtils.addComponent(new JSeparator(), mainPane, 0, 1, 1, 1, 2, 10, 1.0, 0.0, insets);
        LayoutUtils.addComponent(this.contentPane, mainPane, 0, 2, 1, 1, 1, 10, 1.0, 1.0, insets);
        super.getContentPane().add(mainPane);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Application.getInstance().shutdown();
            }
        });
    }

    public Icon getBannerIcon() {
        return this.bannerIcon;
    }

    public void setBannerIcon(Icon bannerIcon) {
        Icon oldValue = this.bannerIcon;
        this.bannerIcon = bannerIcon;
        this.firePropertyChange(PROPERTY_BANNER_ICON, oldValue, bannerIcon);
    }

    public String getBannerText() {
        return this.bannerText;
    }

    public void setBannerText(String bannerText) {
        String oldValue = this.bannerText;
        this.bannerText = bannerText;
        this.firePropertyChange(PROPERTY_BANNER_TEXT, oldValue, bannerText);
    }

    @Override
    public Container getContentPane() {
        return this.contentPane;
    }
}

